## Sid Meier's Civilization 4
from CvPythonExtensions import *
import PyHelpers
import CvUtil
import ScreenInput
import CvScreenEnums
import string

PyPlayer = PyHelpers.PyPlayer
PyInfo = PyHelpers.PyInfo

# globals
gc = CyGlobalContext()
ArtFileMgr = CyArtFileMgr()
localText = CyTranslator()

class CvGreatPersonScreen:
	"Great Person Screen"
	
	def __init__(self):
		self.X_SCREEN = 100
		self.Y_SCREEN = 40
		self.W_SCREEN = 775
		self.H_SCREEN = 660
		self.Y_TITLE = self.Y_SCREEN + 20
		
		self.W_PORTRAIT = 720
		self.H_PORTRAIT = 540
		
		self.X_EXIT = self.X_SCREEN + self.W_SCREEN/2 - 50
		self.Y_EXIT = self.Y_SCREEN + self.H_SCREEN - 50
		self.W_EXIT = 120
		self.H_EXIT = 30
		
		self.PICTURE_BASE = "Art/GreatPeople/%s.dds"
	
	
	
	def interfaceScreen (self, pUnit, pCity):
		szPersonName = pUnit.getNameNoDesc()
		szPicturePath = str(self.PICTURE_BASE %(szPersonName))
			
		screen = CyGInterfaceScreen( "GreatPersonScreen", CvScreenEnums.ERA_MOVIE_SCREEN)
		screen.addPanel("GreatPersonPanel", "", "", true, true,
			self.X_SCREEN, self.Y_SCREEN, self.W_SCREEN, self.H_SCREEN, PanelStyles.PANEL_STYLE_MAIN)
		
		screen.showWindowBackground(True)
		screen.setRenderInterfaceOnly(False)
		screen.setSound("AS2D_NEW_ERA")
		screen.showScreen(PopupStates.POPUPSTATE_MINIMIZED, False)
                		
		# Header...
		szHeader = localText.getText("TXT_KEY_MISC_GP_BORN", (szPersonName, pCity.getName()))
		szHeaderId = "GreatPersonTitleHeader"
		screen.setText(szHeaderId, "Background", szHeader, CvUtil.FONT_CENTER_JUSTIFY,
			       self.X_SCREEN + self.W_SCREEN / 2, self.Y_TITLE, 0, FontTypes.TITLE_FONT, WidgetTypes.WIDGET_GENERAL, -1, -1)
		
		screen.setButtonGFC("GreatPersonExit", localText.getText("TXT_KEY_MAIN_MENU_OK", ()), "", self.X_EXIT, self.Y_EXIT, self.W_EXIT, self.H_EXIT, WidgetTypes.WIDGET_CLOSE_SCREEN, -1, -1, ButtonStyles.BUTTON_STYLE_STANDARD )
		
		screen.addDDSGFC("GreatPersonPortrait", szPicturePath, self.X_SCREEN + 27, self.Y_SCREEN + 50, self.W_PORTRAIT, self.H_PORTRAIT, WidgetTypes.WIDGET_GENERAL, -1, -1 )
				
		return 0
		
	# Will handle the input for this screen...
	def handleInput (self, inputClass):
		return 0

	def update(self, fDelta):
		return

